/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.soap;

import filenet.vw.api.VWException;
import filenet.vw.base.IVWConsole;
import filenet.vw.base.logging.IVWConsoleHandler;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.IVWCommand;
import filenet.vw.server.IVWRouter;
import filenet.vw.server.VWLogonCredentials;
import filenet.vw.soap.VWSOAPRouterURL;
import filenet.vw.soap.util.VWSOAPUtils;
import java.rmi.RemoteException;
import java.util.Vector;

public class VWSOAPCommand
implements IVWCommand,
IVWRouter {
    private static final String m_className = "VWSOAPCommand";
    private static final String SESSION_ID = "sessionId";
    private String m_router = "vwrouter";
    private String m_destination = null;
    private int m_isolatedRegion = -1;
    private String m_serverURL = null;
    private String m_serviceURL = null;
    private String m_token = null;
    private String m_sessionId = null;
    private static Logger logger = Logger.getLogger("filenet.vw.soap");
    private String m_prefix = null;

    public VWSOAPCommand(VWSOAPRouterURL soapRouterURL, String token) {
        this.m_router = soapRouterURL.getRouterName();
        this.m_serverURL = soapRouterURL.getServerURL();
        this.m_token = token;
        this.m_prefix = "soapcommand[" + this.m_router + "] ";
        try {
            this.m_sessionId = System.getProperty(SESSION_ID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "CTOR1", this.m_prefix + "sessionId = " + this.m_sessionId + ", token=" + this.m_token);
        }
    }

    public VWSOAPCommand(String router, String destination, String serverURL, String token, String sessionId) {
        this.m_router = router;
        this.m_destination = destination;
        this.m_serverURL = serverURL;
        this.m_token = token;
        this.m_sessionId = sessionId;
        this.m_prefix = "soapcommand[" + this.m_router + ", " + this.m_destination + "] ";
        if (logger.isFinest()) {
            logger.finest(m_className, "CTOR2", this.m_prefix + "sessionId = " + this.m_sessionId + ", token=" + this.m_token);
        }
    }

    public void setToken(String token) {
        this.m_token = token;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] sendCommand(int RPCnumber, byte[] cmd, int viewId, byte[][] logonHandles, int[] serverIds) throws RemoteException, VWException {
        String m_method = "sendCommand:" + this.m_prefix + "RPC=" + Integer.toString(RPCnumber);
        try {
            try {
                logger.entering(m_className, m_method);
                byte[] byArray = (byte[])VWSOAPUtils.invoke(this.m_serverURL, "sendCommand", new String[]{"routerName", "destination", "RPCnumber", "cmd", "viewId", "logonHandles", "serverIds"}, new Object[]{this.m_router, this.m_destination, new Integer(RPCnumber), cmd, new Integer(viewId), logonHandles, serverIds}, new Class[]{String.class, String.class, Integer.class, byte[].class, Integer.class, byte[][].class, int[].class}, this.m_token, this.m_sessionId);
                Object var9_10 = null;
                logger.exiting(m_className, m_method);
                return byArray;
            }
            catch (VWException vwe) {
                throw vwe;
            }
            catch (Exception e) {
                throw new VWException("soap.soapCommand.sendCommand", "Exception: {0}", e.getMessage());
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            logger.exiting(m_className, m_method);
            throw throwable;
        }
    }

    public Vector getProperties() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public boolean getLoggingState() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public void setLoggingState(boolean logState) throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public boolean getTracingState() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public void setTracingState(boolean state) throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public int getRunState() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public IVWCommand getSession(String destination) throws RemoteException, VWException {
        if (logger.isFinest()) {
            logger.finest(m_className, "getSession", this.m_prefix + "want a new VWSOAPcommand, dest=" + destination);
        }
        return new VWSOAPCommand(this.m_router, destination, this.m_serverURL, this.m_token, this.m_sessionId);
    }

    public IVWCommand[] getAllServers(String aServiceName) throws RemoteException, VWException {
        throw new RemoteException("Not applicable");
    }

    public String getRouterName() throws RemoteException {
        return this.m_router;
    }

    public int getRouterPort() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public int getPPMPort() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public int getBrokerPort() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public int getRMIBacklog() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public void registerConsole(IVWConsole console) throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public void unRegisterConsole(IVWConsole console) throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public String getServiceURL() throws RemoteException {
        if (this.m_serviceURL == null) {
            try {
                logger.entering(m_className, "getServiceURL");
                this.m_serviceURL = (String)VWSOAPUtils.invoke(this.m_serverURL, "getServiceURL", new String[]{"routerName"}, new Object[]{this.m_router}, new Class[]{String.class}, this.m_token, this.m_sessionId);
            }
            catch (Exception e) {
                throw new RemoteException("Failed to get service URL", e);
            }
        }
        logger.exiting(m_className, "getServiceURL", this.m_serviceURL);
        return this.m_serviceURL;
    }

    public int getIsolatedRegion() throws RemoteException {
        if (-1 == this.m_isolatedRegion) {
            try {
                Integer i = (Integer)VWSOAPUtils.invoke(this.m_serverURL, "getIsolatedRegion", new String[]{"routerName"}, new Object[]{this.m_router}, new Class[]{String.class}, this.m_token, this.m_sessionId);
                this.m_isolatedRegion = i;
            }
            catch (Exception e) {
                throw new RemoteException("Failed to get isolated region", e);
            }
        }
        logger.exiting(m_className, "getIsolatedRegion", Integer.toString(this.m_isolatedRegion));
        return this.m_isolatedRegion;
    }

    public void stop() throws RemoteException, VWException {
        throw new RemoteException("Not applicable");
    }

    public long getConnectRetryTime() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public void setConnectRetryTime(long retrytime) throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public void setDebugLevel(int debugOn) throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public int getDebugLevel() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    public String getToken(String name, String id) throws RemoteException, VWException {
        throw new VWException("soap.VWSOAPCommand.getToken", "Not applicable.");
    }

    public IVWConsoleHandler getConsoleHandler() throws RemoteException {
        throw new RemoteException("Not applicable");
    }

    protected void cleanup() {
        try {
            VWSOAPUtils.invoke(this.m_serverURL, "cleanup", null, null, null, null, this.m_sessionId);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void finalize() {
        this.cleanup();
    }

    public VWLogonCredentials getAuthorization(String identifier) throws RemoteException, VWException {
        String method = "getAuthorization";
        throw new VWException("notImplemented", "{0} Should not be here!! This function is not implemented!", method);
    }
}

